﻿/// <reference name="MicrosoftAjax.js"/>
// StackTrace Adopted from: http://www.helephant.com/Article.aspx?ID=675

StackTrace = function _StackTrace() {
    /// <summary>
    /// Provides a way to create a stack trace from an object.
    /// </summary>
    StackTrace.initializeBase(this);
    this._maxRecursion = 20;
};

StackTrace._getFunctionName = function _StackTrace$_getFunctionName (func) { 
    if(func.name) { 
        return func.name; 
    } 
    var fnText = func.toString(); 
    var fnName = fnText.substring(fnText.indexOf('function') + 8, fnText.indexOf('(')); 
    if(fnName !== null && fnName !== "") { 
        return fnName;
    }
    return "anonymous"; 
}

StackTrace._getSignature = function _StackTrace$_getSignature(func) {
    var signature = new Sys.StringBuilder(this._getFunctionName(func));
    signature.append("(");
    for(var i=0; i < func.arguments.length; i++) {
	    var nextArgument = func.arguments[i];
	    if(nextArgument.length > 30) {
		    nextArgument = nextArgument.substring(0, 30) + "...";
		}
	    signature.append(String.format("'{0}'", nextArgument)); 
		
	    // parameter separator
	    if (i < func.arguments.length - 1) {
		    signature.append(", ");
        }
    }
    signature.append(")");
    return signature.toString();
}
    
StackTrace.createStackTrace = function _StackTrace$createStackTrace(startingPoint) {
    /// <summary>Creates a Stack Trace from the startPoint</summary>
    /// <param name="startingPoint" type="Function" />
    var e = Function._validateParams(arguments, [
        {name: "startingPoint", type: Function }
    ]);
    if (e) throw e;
    
    var numberOfRecursions = 0;
    var stackTraceMessage = new Sys.StringBuilder("Stack Trace");
    stackTraceMessage.appendLine();
    var nextCaller = startingPoint;
    
    while(nextCaller && numberOfRecursions < this._maxRecursion) {
	    stackTraceMessage.appendLine(this._getSignature(nextCaller));
	    nextCaller = nextCaller.caller;
	    numberOfRecursions++;
    }
    stackTraceMessage.appendLine();
    stackTraceMessage.appendLine();
	
    return stackTraceMessage.toString();
}

//_StackTrace.prototype = {
//    _getFunctionName: function _StackTrace$_getFunctionName (func) { 
//        if(func.name) { 
//            return func.name; 
//        } 
//        var fnText = func.toString(); 
//        var fnName = fnText.substring(fnText.indexOf('function') + 8, fnText.indexOf('(')); 
//        if(fnName !== null && fnName !== "") { 
//            return fnName;
//        }
//        return "anonymous"; 
//    },

//    _getSignature: function _StackTrace$_getSignature(func) {
//	    var signature = new Sys.StringBuilder(this._getFunctionName(func));
//	    signature.append("(");
//	    for(var i=0; i < func.arguments.length; i++) {
//		    var nextArgument = func.arguments[i];
//		    if(nextArgument.length > 30) {
//			    nextArgument = nextArgument.substring(0, 30) + "...";
//    		}
//		    signature.append(String.format("'{0}'", nextArgument)); 
//    		
//		    // parameter separator
//		    if (i < func.arguments.length - 1) {
//			    signature.append(", ");
//            }
//	    }
//	    signature.append(")");
//	    return signature.toString();
//    },
//    
//    createStackTrace: function _StackTrace$createStackTrace(startingPoint) {
//        /// <summary>Creates a Stack Trace from the startPoint</summary>
//        /// <param name="startingPoint" type="Function" />
//        var e = Function._validateParams(arguments, [
//            {name: "startingPoint", type: Function }
//        ]);
//        if (e) throw e;
//        
//        var numberOfRecursions = 0;
//	    var stackTraceMessage = new Sys.StringBuilder("Stack Trace");
//	    stackTraceMessage.appendLine();
//	    var nextCaller = startingPoint;
//	    
//	    while(nextCaller && numberOfRecursions < this._maxRecursion) {
//		    stackTraceMessage.appendLine(this._getSignature(nextCaller));
//		    nextCaller = nextCaller.caller;
//		    numberOfRecursions++;
//	    }
//        stackTraceMessage.appendLine();
//        stackTraceMessage.appendLine();
//    	
//	    return stackTraceMessage.toString();
//    }
//}
StackTrace.registerClass("StackTrace");

//Sys.Application.add_init(
//    function() { 
//        StackTrace = new _StackTrace(); 
//    }
//);
if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();
